package postgres

import (
	"fmt"
	"github.com/pkg/errors"
	"strings"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
)

func (s *store) OrderFeaturedCarousel(req *discovery.OrderFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	var carousel model.FeaturedCarousel

	if err := s.db.Where(model.FeaturedCarousel{ID: req.GetCarouselID()}).First(&carousel).Error; err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		return nil, errors.Wrapf(err, "error getting carousel %s", req.GetCarouselID())
	}

	scope := s.db.NewScope(&model.FeaturedCarouselEntry{})
	tableName := scope.GetModelStruct().TableName(s.db)

	// Table name presumed to be escaped since it's from gorm
	sql := fmt.Sprintf(`
		update %s as t set "order" = c.o from
		   (values ?)
		as c(id, o)
		where c.id = t.id and t.carousel_id = ?;
	`, tableName)

	var valueStrings []string
	for i, eid := range req.GetEntryIDs() {
		valueString := fmt.Sprintf("('%s', %d)", eid, i)
		valueStrings = append(valueStrings, valueString)
	}
	values := strings.Join(valueStrings, ",")

	if err := s.db.Exec(sql, values, req.GetCarouselID()).Error; err != nil {
		return nil, errors.Wrapf(err, "error changing order of carousel %s", req.GetCarouselID())
	}

	return &carousel, nil
}
