package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/pkg/errors"
)

func (s *store) RemoveExtensionFromCategory(req *discovery.RemoveExtensionFromCategoryRequest) (*model.CuratedCategoryExtension, error) {
	err := s.db.Delete(model.CuratedCategoryExtension{},
		"category_id = ? AND extension_id = ?", req.GetCategoryID(), req.GetExtensionID()).Error
	if err != nil {
		return nil, errors.Wrapf(err, "error removing extension %s from category %s",
			req.GetExtensionID(), req.GetCategoryID())
	}

	return &model.CuratedCategoryExtension{
		CategoryID:  req.GetCategoryID(),
		ExtensionID: req.GetExtensionID(),
	}, nil
}
