package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/jinzhu/gorm"
)

func (s *store) SoftDeleteDiscoveryVersionData(req *discovery.DeleteExtensionVersionDiscoveryDataRequest) error {
	// Note: This soft deletes because of gorm magic.  See http://gorm.io/docs/delete.html#Soft-Delete
	var discoveryData model.ExtensionDiscoveryData
	if err := s.db.Where(&model.ExtensionDiscoveryData{
		ExtensionID: req.GetExtensionID(),
		Version:     req.GetVersion(),
	}).Delete(&discoveryData).Error; err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return data.ErrNotFound
		}
		// Assumes that all errors here are because the DB was unavailable
		return data.ErrUnavailable
	}

	return nil
}
