package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"

	"github.com/pkg/errors"
)

func (s *store) UpdateCategory(req *discovery.UpdateCategoryRequest) (*model.Category, error) {
	category := req.GetCategory()

	var cat model.Category

	if err := s.db.Where(&model.Category{ID: req.GetCategoryID()}).First(&cat).Error; err != nil {
		return nil, data.ErrCategoryNotFound
	}

	err := data.ValidateCategoryUpdate(&cat, category)
	if err != nil {
		return nil, errors.Wrapf(err, "error validating category update (cat = %+v) (update = %+v)", cat, category)
	}

	if category.GetType() != nil {
		cat.Type = category.GetType().GetValue()
	}
	if category.GetSortKey() != nil {
		cat.SortKey = category.GetSortKey().GetValue()
	}
	if category.GetReadonly() != nil {
		cat.Readonly = category.GetReadonly().GetValue()
	}
	if category.GetOrder() != nil {
		cat.Order = category.GetOrder().GetValue()
	}
	if category.GetVisible() != nil {
		cat.Visible = category.GetVisible().GetValue()
	}

	s.db.Save(&cat)

	return &cat, nil
}
