package postgres

import (
	discovery "code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"github.com/jinzhu/gorm"
)

func (s *store) UpdateDiscoveryData(req *discovery.UpdateExtensionVersionDiscoveryDataRequest) (*model.ExtensionDiscoveryData, error) {
	reqData := req.GetUpdateData()
	var discoveryData model.ExtensionDiscoveryData
	if err := s.db.Where(&model.ExtensionDiscoveryData{
		ExtensionID: reqData.GetExtensionID(),
		Version:     reqData.GetVersion(),
	}).First(&discoveryData).Error; err != nil {
		if gorm.IsRecordNotFoundError(err) {
			return nil, data.ErrNotFound
		}
		// Assumes that all errors here are because the DB was unavailable
		return nil, data.ErrUnavailable
	}

	if reqData.GetName() != nil {
		discoveryData.Name = reqData.GetName().GetValue()
	}
	if reqData.GetAuthorName() != nil {
		discoveryData.AuthorName = reqData.GetAuthorName().GetValue()
	}
	if reqData.GetCategories() != nil {
		discoveryData.Categories = reqData.GetCategories().GetValues()
	}
	if reqData.GetDescription() != nil {
		discoveryData.Description = reqData.GetDescription().GetValue()
	}
	if reqData.GetEULATOSURL() != nil {
		discoveryData.EULATOSURL = reqData.GetEULATOSURL().GetValue()
	}
	if reqData.GetGames() != nil {
		discoveryData.Games = reqData.GetGames().GetValues()
	}
	if reqData.GetIconPaths() != nil {
		discoveryData.IconPaths = model.MapToHstore(reqData.GetIconPaths().GetValues())
	}
	if reqData.GetIconURLs() != nil {
		discoveryData.IconURLs = model.MapToHstore(reqData.GetIconURLs().GetValues())
	}
	if reqData.GetPrivacyPolicyURL() != nil {
		discoveryData.PrivacyPolicyURL = reqData.GetPrivacyPolicyURL().GetValue()
	}
	if reqData.GetScreenshotPaths() != nil {
		discoveryData.ScreenshotPaths = reqData.GetScreenshotPaths().GetValues()
	}
	if reqData.GetScreenshotURLs() != nil {
		discoveryData.ScreenshotURLs = reqData.GetScreenshotURLs().GetValues()
	}
	if reqData.GetSummary() != nil {
		discoveryData.Summary = reqData.GetSummary().GetValue()
	}
	if reqData.GetSupportEmail() != nil {
		discoveryData.SupportEmail = reqData.GetSupportEmail().GetValue()
	}
	if reqData.GetViewerSummary() != nil {
		discoveryData.ViewerSummary = reqData.GetViewerSummary().GetValue()
	}

	s.db.Save(&discoveryData)

	entry := model.ExtensionDiscoveryData{
		Timestamps: model.Timestamps{
			CreatedAt: discoveryData.CreatedAt,
			UpdatedAt: discoveryData.UpdatedAt,
		},
		ExtensionID:      discoveryData.ExtensionID,
		Version:          discoveryData.Version,
		AuthorName:       discoveryData.AuthorName,
		Categories:       discoveryData.Categories,
		Description:      discoveryData.Description,
		EULATOSURL:       discoveryData.EULATOSURL,
		Games:            discoveryData.Games,
		IconPaths:        discoveryData.IconPaths,
		IconURLs:         discoveryData.IconURLs,
		Name:             discoveryData.Name,
		PrivacyPolicyURL: discoveryData.PrivacyPolicyURL,
		ScreenshotPaths:  discoveryData.ScreenshotPaths,
		ScreenshotURLs:   discoveryData.ScreenshotURLs,
		Summary:          discoveryData.Summary,
		SupportEmail:     discoveryData.SupportEmail,
		ViewerSummary:    discoveryData.ViewerSummary,
	}

	return &entry, nil
}
