package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
	"code.justin.tv/extensions/discovery/twirputils"
)

func (s *store) UpdateFeaturedCarousel(req *discovery.UpdateFeaturedCarouselRequest) (*model.FeaturedCarousel, error) {
	var carousel model.FeaturedCarousel

	if err := s.db.Where(&model.FeaturedCarousel{ID: req.GetCarouselID()}).First(&carousel).Error; err != nil {
		return nil, data.ErrNotFound
	}
	startTime, err := twirputils.UnwrapTimestampPointer(req.GetFeaturedCarousel().GetStartTime())
	if err != nil {
		return nil, data.ErrMissingParameter
	}

	carousel.ScheduleID = req.GetFeaturedCarousel().GetScheduleID()
	carousel.StartTime = *startTime

	s.db.Save(&carousel)

	return &carousel, nil
}
