package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) UpdateFeaturedCarouselEntry(req *discovery.UpdateFeaturedCarouselEntryRequest) (*model.FeaturedCarouselEntry, error) {
	var entry model.FeaturedCarouselEntry

	if err := s.db.Where(&model.FeaturedCarouselEntry{ID: req.GetID()}).First(&entry).Error; err != nil {
		return nil, data.ErrNotFound
	}

	if req.GetFeaturedCarouselEntry().GetCarouselID() != nil {
		entry.CarouselID = req.GetFeaturedCarouselEntry().GetCarouselID().GetValue()
	}
	if req.GetFeaturedCarouselEntry().GetContent() != nil {
		entry.ClickThrough = req.GetFeaturedCarouselEntry().GetContent().GetClickThrough()
		entry.ImageURL = req.GetFeaturedCarouselEntry().GetContent().GetImageURL()
		entry.Title = req.GetFeaturedCarouselEntry().GetContent().GetTitle()
	}
	if req.GetFeaturedCarouselEntry().GetOrder() != nil {
		entry.Order = req.GetFeaturedCarouselEntry().GetOrder().GetValue()
	}

	s.db.Save(&entry)

	return &entry, nil
}
