package postgres

import (
	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/data/model"
)

func (s *store) UpdateFeaturedSchedule(req *discovery.UpdateFeaturedScheduleRequest) (*model.FeaturedCarouselSchedule, error) {
	var schedule model.FeaturedCarouselSchedule

	if err := s.db.Where(&model.FeaturedCarouselSchedule{ID: req.GetScheduleID()}).First(&schedule).Error; err != nil {
		return nil, data.ErrNotFound
	}

	schedule.Description = req.GetFeaturedSchedule().GetDescription()

	s.db.Save(&schedule)

	return &schedule, nil
}
