package model

import "github.com/jinzhu/gorm/dialects/postgres"

// Converts a map[string]string to a postgres hstore
func MapToHstore(m map[string]string) postgres.Hstore {
	hstore := postgres.Hstore{}
	for k, v := range m {
		hstore[k] = &v
	}
	return hstore
}

// Converts a postgres hstore to a map[string]string *BUT*
// explicitly ignores any keys which have nil values in the store
func HstoreToMap(hstore postgres.Hstore) map[string]string {
	m := make(map[string]string)
	for k, v := range hstore {
		if v != nil {
			m[k] = *v
		}
	}
	return m
}
