package model

import "code.justin.tv/extensions/discovery/cmd/discovery/rpc"

//go:generate counterfeiter . Store
// Store methods should return errors from errors.go or errors that have been created or wrapped using github.com/pkg/errors
// so they contain stacktraces that can be logged by the twirp wrappers at the end of processing.
type Store interface {
	AddExtensionToCategory(*discovery.AddExtensionToCategoryRequest) (*CuratedCategoryExtension, error)
	CreateCategory(*discovery.AddCategoryRequest) (*Category, error)
	DeleteCategory(*discovery.DeleteCategoryRequest) error
	EditCategoryTranslation(*discovery.EditCategoryTranslationRequest) (*CategoryTranslation, *Category, error)
	GetCategories(*discovery.GetCategoriesRequest) ([]*Category, []*CategoryTranslation, int32, error)
	GetCategory(*discovery.GetCategoryRequest) (*Category, *CategoryTranslation, error)
	GetExtensionsForCategory(*discovery.GetCategoryExtensionsRequest) ([]*CuratedCategoryExtension, int32, error)
	OrderCategories(*discovery.OrderCategoriesRequest) ([]*Category, error)
	OrderCategory(*discovery.OrderCategoryRequest) (*Category, error)
	RemoveExtensionFromCategory(*discovery.RemoveExtensionFromCategoryRequest) (*CuratedCategoryExtension, error)
	UpdateCategory(*discovery.UpdateCategoryRequest) (*Category, error)

	CreateFeaturedSchedule(*discovery.AddFeaturedScheduleRequest) (*FeaturedCarouselSchedule, error)
	GetFeaturedSchedules(*discovery.GetFeaturedSchedulesRequest) ([]*FeaturedCarouselSchedule, int32, error)
	GetFeaturedSchedule(*discovery.GetFeaturedScheduleRequest) (*FeaturedCarouselSchedule, error)
	DeleteFeaturedSchedule(*discovery.DeleteFeaturedScheduleRequest) (*FeaturedCarouselSchedule, error)
	UpdateFeaturedSchedule(*discovery.UpdateFeaturedScheduleRequest) (*FeaturedCarouselSchedule, error)

	CreateFeaturedCarousel(*discovery.AddFeaturedCarouselRequest) (*FeaturedCarousel, error)
	GetFeaturedCarousel(*discovery.GetFeaturedCarouselRequest) (*FeaturedCarousel, error)
	GetFeaturedCarousels(*discovery.GetFeaturedCarouselsRequest) ([]*FeaturedCarousel, int32, error)
	DeleteFeaturedCarousel(*discovery.DeleteFeaturedCarouselRequest) (*FeaturedCarousel, error)
	UpdateFeaturedCarousel(*discovery.UpdateFeaturedCarouselRequest) (*FeaturedCarousel, error)
	OrderFeaturedCarousel(*discovery.OrderFeaturedCarouselRequest) (*FeaturedCarousel, error)

	GetCurrentCarousel(*discovery.GetFeaturedScheduleRequest) (*FeaturedCarousel, error)

	CreateFeaturedCarouselEntry(*discovery.AddFeaturedCarouselEntryRequest) (*FeaturedCarouselEntry, error)
	GetFeaturedCarouselEntry(*discovery.GetFeaturedCarouselEntryRequest) (*FeaturedCarouselEntry, error)
	GetFeaturedCarouselEntries(*discovery.GetFeaturedCarouselEntriesRequest) ([]*FeaturedCarouselEntry, int32, error)
	DeleteFeaturedCarouselEntry(*discovery.DeleteFeaturedCarouselEntryRequest) (*FeaturedCarouselEntry, error)
	UpdateFeaturedCarouselEntry(*discovery.UpdateFeaturedCarouselEntryRequest) (*FeaturedCarouselEntry, error)

	GetEntriesForCarousel(*discovery.GetFeaturedCarouselRequest) ([]*FeaturedCarouselEntry, error)

	// Extension discovery data modifications
	PutDiscoveryData(request *discovery.PutExtensionVersionDiscoveryDataRequest) (*ExtensionDiscoveryData, error)
	UpdateDiscoveryData(request *discovery.UpdateExtensionVersionDiscoveryDataRequest) (*ExtensionDiscoveryData, error)
	GetDiscoveryData(request *discovery.GetExtensionVersionDiscoveryDataRequest) (*ExtensionDiscoveryData, error)
	AdminGetDiscoveryData(request *discovery.GetExtensionVersionDiscoveryDataRequest) (*ExtensionDiscoveryData, error)
	SoftDeleteDiscoveryVersionData(request *discovery.DeleteExtensionVersionDiscoveryDataRequest) error
	HardDeleteDiscoveryData(request *discovery.HardDeleteExtensionDiscoveryDataRequest) error

	// Non-twirp exposed
	GetCarouselsByScheduleIDs([]string) ([]*FeaturedCarousel, error)
	GetCarouselEntriesByCarouselIDs([]string) ([][]*FeaturedCarouselEntry, error)

	// for test environments only
	IsResetEnabled() bool
	EnableDataReset()
	ResetAllData() error
}
