package logger

import "encoding/json"

var _ Logger = &JsonLogger{}

type JsonLogger struct {
	logger *json.Encoder
}

type JsonLogMessage struct {
	Msg        string                 `json:"msg"`
	Dimensions map[string]interface{} `json:"dimensions"`
	Stacktrace *TraceChain            `json:",omitempty"`
}

func NewJsonLogger(encoder *json.Encoder) *JsonLogger {
	return &JsonLogger{
		logger: encoder,
	}
}

func (l *JsonLogger) Log(msg string, dimensions map[string]interface{}, stacktrace *TraceChain) {
	_ = l.logger.Encode(JsonLogMessage{
		Msg:        msg,
		Dimensions: dimensions,
		Stacktrace: stacktrace,
	})
}

func (l *JsonLogger) Info(msg string, dimensions map[string]interface{}, stacktrace *TraceChain) {
	if dimensions == nil {
		dimensions = map[string]interface{}{}
	}

	dimensions["logLevel"] = "Info"

	_ = l.logger.Encode(JsonLogMessage{
		Msg:        msg,
		Dimensions: dimensions,
		Stacktrace: stacktrace,
	})
}

func (l *JsonLogger) Warn(msg string, dimensions map[string]interface{}, stacktrace *TraceChain) {
	if dimensions == nil {
		dimensions = map[string]interface{}{}
	}

	dimensions["logLevel"] = "Warn"

	_ = l.logger.Encode(JsonLogMessage{
		Msg:        msg,
		Dimensions: dimensions,
		Stacktrace: stacktrace,
	})
}

func (l *JsonLogger) Error(msg string, dimensions map[string]interface{}, stacktrace *TraceChain) {
	if dimensions == nil {
		dimensions = map[string]interface{}{}
	}

	dimensions["logLevel"] = "Error"

	_ = l.logger.Encode(JsonLogMessage{
		Msg:        msg,
		Dimensions: dimensions,
		Stacktrace: stacktrace,
	})
}

func (l *JsonLogger) Fatal(msg string, dimensions map[string]interface{}, stacktrace *TraceChain) {
	if dimensions == nil {
		dimensions = map[string]interface{}{}
	}

	dimensions["logLevel"] = "Fatal"

	_ = l.logger.Encode(JsonLogMessage{
		Msg:        msg,
		Dimensions: dimensions,
		Stacktrace: stacktrace,
	})
}
