package logger

type Logger interface {
	// Log logs the string with the optional dimensions and the optional stacktrace
	Log(msg string, dimension map[string]interface{}, stacktrace *TraceChain)

	// Info is a helper function that automatically includes a logLevel: Info dimension
	Info(msg string, dimension map[string]interface{}, stacktrace *TraceChain)
	// Warn is a helper function that automatically includes a logLevel: Warn dimension
	Warn(msg string, dimension map[string]interface{}, stacktrace *TraceChain)
	// Error is a helper function that automatically includes a logLevel: Error dimension
	Error(msg string, dimension map[string]interface{}, stacktrace *TraceChain)
	// Fatal is a helper function that automatically includes a logLevel: Fatal dimension
	Fatal(msg string, dimension map[string]interface{}, stacktrace *TraceChain)
}
