package interfaces

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
)

type PaginationOptions struct {
	Limit  int
	Offset int
}

type DiscoveryManager interface {
	CategoryManager
	ExtensionManager
	FeaturedScheduleManager
	FeaturedCarouselManager
	FeaturedCarouselEntryManager
	ExtensionDiscoveryDataManager
	TestableManager
}

type CategoryManager interface {
	CreateCategory(context.Context, *discovery.AddCategoryRequest) (*discovery.CategoryDocument, error)
	EditCategoryTranslation(context.Context, *discovery.EditCategoryTranslationRequest) (*discovery.CategoryDocument, error)
	GetCategories(context.Context, *discovery.GetCategoriesRequest) (*discovery.CategoriesDocument, error)
	GetCategory(context.Context, *discovery.GetCategoryRequest) (*discovery.CategoryDocument, error)
	OrderCategories(context.Context, *discovery.OrderCategoriesRequest) ([]*discovery.CategoryDocument, error)
	OrderCategory(context.Context, *discovery.OrderCategoryRequest) (*discovery.CategoryDocument, error)
	UpdateCategory(context.Context, *discovery.UpdateCategoryRequest) (*discovery.CategoryDocument, error)
}

type ExtensionManager interface {
	AddExtensionToDeveloperCategory(context.Context, *discovery.AddExtensionToCategoryRequest) (*discovery.ExtensionCategoryMembershipDocument, error)
	GetExtensionsForCategory(context.Context, *discovery.GetCategoryExtensionsRequest) (*discovery.CategoryExtensionsDocument, error)
	DeleteCategory(context.Context, *discovery.DeleteCategoryRequest) (*discovery.DeleteCategoryResponse, error)

	AddExtensionToCuratedCategory(context.Context, *discovery.AddExtensionToCategoryRequest) (*discovery.ExtensionCategoryMembershipDocument, error)
	RemoveExtensionFromCategory(context.Context, *discovery.RemoveExtensionFromCategoryRequest) (*discovery.ExtensionCategoryMembershipDocument, error)
}

type FeaturedScheduleManager interface {
	CreateFeaturedSchedule(context.Context, *discovery.AddFeaturedScheduleRequest) (*discovery.FeaturedScheduleDocument, error)
	GetFeaturedSchedules(context.Context, *discovery.GetFeaturedSchedulesRequest) (*discovery.FeaturedSchedulesDocument, error)
	GetFeaturedSchedule(context.Context, *discovery.GetFeaturedScheduleRequest) (*discovery.FeaturedScheduleDocument, error)
	DeleteFeaturedSchedule(context.Context, *discovery.DeleteFeaturedScheduleRequest) (*discovery.FeaturedScheduleDocument, error)
	UpdateFeaturedSchedule(context.Context, *discovery.UpdateFeaturedScheduleRequest) (*discovery.FeaturedScheduleDocument, error)
}

type FeaturedCarouselManager interface {
	CreateFeaturedCarousel(context.Context, *discovery.AddFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error)
	GetFeaturedCarousel(context.Context, *discovery.GetFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error)
	GetFeaturedCarousels(context.Context, *discovery.GetFeaturedCarouselsRequest) (*discovery.FeaturedCarouselsDocument, error)
	DeleteFeaturedCarousel(context.Context, *discovery.DeleteFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error)
	UpdateFeaturedCarousel(context.Context, *discovery.UpdateFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error)
	OrderFeaturedCarousel(context.Context, *discovery.OrderFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error)
}

type FeaturedCarouselEntryManager interface {
	CreateFeaturedCarouselEntry(context.Context, *discovery.AddFeaturedCarouselEntryRequest) (*discovery.FeaturedCarouselEntryDocument, error)
	GetFeaturedCarouselEntry(context.Context, *discovery.GetFeaturedCarouselEntryRequest) (*discovery.FeaturedCarouselEntryDocument, error)
	GetFeaturedCarouselEntries(context.Context, *discovery.GetFeaturedCarouselEntriesRequest) (*discovery.FeaturedCarouselEntriesDocument, error)
	DeleteFeaturedCarouselEntry(context.Context, *discovery.DeleteFeaturedCarouselEntryRequest) (*discovery.FeaturedCarouselEntryDocument, error)
	UpdateFeaturedCarouselEntry(context.Context, *discovery.UpdateFeaturedCarouselEntryRequest) (*discovery.FeaturedCarouselEntryDocument, error)
}

type ExtensionDiscoveryDataManager interface {
	PutExtensionVersionDiscoveryData(context.Context, *discovery.PutExtensionVersionDiscoveryDataRequest) (*discovery.ExtensionVersionDiscoveryDocument, error)
	// UpdateExtensionVersionDiscoveryData is used internally for APIs intended to update but not create, eg add game to extension
	UpdateExtensionVersionDiscoveryData(context.Context, *discovery.UpdateExtensionVersionDiscoveryDataRequest) (*discovery.ExtensionVersionDiscoveryDocument, error)
	GetExtensionVersionDiscoveryData(context.Context, *discovery.GetExtensionVersionDiscoveryDataRequest) (*discovery.ExtensionVersionDiscoveryDocument, error)
	DeleteExtensionVersionDiscoveryData(context.Context, *discovery.DeleteExtensionVersionDiscoveryDataRequest) error
	HardDeleteExtensionDiscoveryData(context.Context, *discovery.HardDeleteExtensionDiscoveryDataRequest) error

	/* The following APIs are basically updates but are in the manager to keep business logic there */

	AddGameToExtension(context.Context, *discovery.AddGameToExtensionRequest) (*discovery.AddGameToExtensionResponse, error)
	// DeleteGameFromExtension removes a given game from the extension if present.  Does *not* guarantee preservation of order
	// of the games slice
	DeleteGameFromExtension(context.Context, *discovery.DeleteGameFromExtensionRequest) (*discovery.DeleteGameFromExtensionResponse, error)
}

type TestableManager interface {
	// for testing use; requires that store.EnableDataReset() was called previously
	IsResetEnabled() bool
	ResetAllData() error
}
