package manager

import (
	"context"

	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/interfaces"

	"github.com/twitchtv/twirp"
)

// actual key is the address of this var, which is unique in program space
var managerKey int

// StoreDiscoveryManager places a manager into a context
func StoreDiscoveryManager(ctx context.Context, mgr interfaces.DiscoveryManager) context.Context {
	return context.WithValue(ctx, &managerKey, mgr)
}

// LoadDiscoveryManager retrieves a manager from a context
func LoadDiscoveryManager(ctx context.Context) (interfaces.DiscoveryManager, error) {
	value, ok := ctx.Value(&managerKey).(interfaces.DiscoveryManager)
	if !ok {
		return nil, data.ErrUnavailable
	}
	return value, nil
}

// DiscoveryManagerServerHook allows added the discovery manager to the context for API handling
type DiscoveryManagerServerHook struct {
	Manager interfaces.DiscoveryManager
}

func (s *DiscoveryManagerServerHook) ServerHooks() *twirp.ServerHooks {
	return &twirp.ServerHooks{
		RequestRouted: func(ctx context.Context) (context.Context, error) {
			ctx = StoreDiscoveryManager(ctx, s.Manager)
			return ctx, nil
		},
	}
}
