package manager

import (
	"context"

	"code.justin.tv/extensions/discovery/cmd/discovery/rpc"
	"code.justin.tv/extensions/discovery/data"
	"code.justin.tv/extensions/discovery/interfaces"
)

var _ interfaces.DiscoveryManager = &nullDiscoveryManager{}

type nullDiscoveryManager struct{}

func (*nullDiscoveryManager) CreateCategory(context.Context, *discovery.AddCategoryRequest) (*discovery.CategoryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) UpdateCategory(context.Context, *discovery.UpdateCategoryRequest) (*discovery.CategoryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) AddExtensionToDeveloperCategory(context.Context, *discovery.AddExtensionToCategoryRequest) (*discovery.ExtensionCategoryMembershipDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) AddExtensionToCuratedCategory(context.Context, *discovery.AddExtensionToCategoryRequest) (*discovery.ExtensionCategoryMembershipDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetExtensionsForCategory(context.Context, *discovery.GetCategoryExtensionsRequest) (*discovery.CategoryExtensionsDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) RemoveExtensionFromCategory(context.Context, *discovery.RemoveExtensionFromCategoryRequest) (*discovery.ExtensionCategoryMembershipDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) DeleteCategory(context.Context, *discovery.DeleteCategoryRequest) (*discovery.DeleteCategoryResponse, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetCategories(context.Context, *discovery.GetCategoriesRequest) (*discovery.CategoriesDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) EditCategoryTranslation(context.Context, *discovery.EditCategoryTranslationRequest) (*discovery.CategoryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) OrderCategories(context.Context, *discovery.OrderCategoriesRequest) ([]*discovery.CategoryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetCategory(context.Context, *discovery.GetCategoryRequest) (*discovery.CategoryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) OrderCategory(context.Context, *discovery.OrderCategoryRequest) (*discovery.CategoryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) CreateFeaturedSchedule(context.Context, *discovery.AddFeaturedScheduleRequest) (*discovery.FeaturedScheduleDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetFeaturedSchedules(context.Context, *discovery.GetFeaturedSchedulesRequest) (*discovery.FeaturedSchedulesDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetFeaturedSchedule(context.Context, *discovery.GetFeaturedScheduleRequest) (*discovery.FeaturedScheduleDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) DeleteFeaturedSchedule(context.Context, *discovery.DeleteFeaturedScheduleRequest) (*discovery.FeaturedScheduleDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) UpdateFeaturedSchedule(context.Context, *discovery.UpdateFeaturedScheduleRequest) (*discovery.FeaturedScheduleDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) CreateFeaturedCarousel(context.Context, *discovery.AddFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetFeaturedCarousel(context.Context, *discovery.GetFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetFeaturedCarousels(context.Context, *discovery.GetFeaturedCarouselsRequest) (*discovery.FeaturedCarouselsDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) DeleteFeaturedCarousel(context.Context, *discovery.DeleteFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) UpdateFeaturedCarousel(context.Context, *discovery.UpdateFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) OrderFeaturedCarousel(context.Context, *discovery.OrderFeaturedCarouselRequest) (*discovery.FeaturedCarouselDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) CreateFeaturedCarouselEntry(context.Context, *discovery.AddFeaturedCarouselEntryRequest) (*discovery.FeaturedCarouselEntryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetFeaturedCarouselEntry(context.Context, *discovery.GetFeaturedCarouselEntryRequest) (*discovery.FeaturedCarouselEntryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetFeaturedCarouselEntries(context.Context, *discovery.GetFeaturedCarouselEntriesRequest) (*discovery.FeaturedCarouselEntriesDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) DeleteFeaturedCarouselEntry(context.Context, *discovery.DeleteFeaturedCarouselEntryRequest) (*discovery.FeaturedCarouselEntryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) UpdateFeaturedCarouselEntry(context.Context, *discovery.UpdateFeaturedCarouselEntryRequest) (*discovery.FeaturedCarouselEntryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) PutExtensionVersionDiscoveryData(context.Context, *discovery.PutExtensionVersionDiscoveryDataRequest) (*discovery.ExtensionVersionDiscoveryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) AddGameToExtension(context.Context, *discovery.AddGameToExtensionRequest) (*discovery.AddGameToExtensionResponse, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) DeleteGameFromExtension(context.Context, *discovery.DeleteGameFromExtensionRequest) (*discovery.DeleteGameFromExtensionResponse, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) UpdateExtensionVersionDiscoveryData(context.Context, *discovery.UpdateExtensionVersionDiscoveryDataRequest) (*discovery.ExtensionVersionDiscoveryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) GetExtensionVersionDiscoveryData(context.Context, *discovery.GetExtensionVersionDiscoveryDataRequest) (*discovery.ExtensionVersionDiscoveryDocument, error) {
	return nil, data.ErrUnavailable
}

func (*nullDiscoveryManager) DeleteExtensionVersionDiscoveryData(context.Context, *discovery.DeleteExtensionVersionDiscoveryDataRequest) error {
	return data.ErrUnavailable
}

func (*nullDiscoveryManager) HardDeleteExtensionDiscoveryData(context.Context, *discovery.HardDeleteExtensionDiscoveryDataRequest) error {
	return data.ErrUnavailable
}

func (*nullDiscoveryManager) IsResetEnabled() bool {
	return false
}

func (*nullDiscoveryManager) ResetAllData() error {
	return data.ErrUnavailable
}
