package sliceutils

// In returns true if the string is exactly matched by an array element
func In(val string, array []string) bool {
	for _, e := range array {
		if e == val {
			return true
		}
	}
	return false
}

// Int64Find returns the index and true if a given int64 value is fonud in the provided slice
// or -1 and false if the value is not in the slice
func Int64Find(val int64, array []int64) (int, bool) {
	for i, e := range array {
		if e == val {
			return i, true
		}
	}
	return -1, false
}

// Int64RemoveIndex removes a given index from an int64 slice.
// Returns the input slice with no modification if the index is not within the bound of the slice.
func Int64RemoveIndex(i int, array []int64) []int64 {
	length := len(array)
	if i < 0 || i >= length {
		return array
	}

	array[i] = array[length-1]
	array[length-1] = 0
	array = array[:length-1]
	return array
}

func Subset(val []string, array []string) bool {
	for _, e := range val {
		if !In(e, array) {
			return false
		}
	}
	return true
}

func Equivalent(lhs, rhs []string) bool {
	if len(lhs) != len(rhs) {
		return false
	}
	return Subset(lhs, rhs)
}
