package sliceutils

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestIn(t *testing.T) {
	assert.True(t, In("a", []string{"b", "a"}))
	assert.False(t, In("a", []string{"b", "c"}))
	assert.False(t, In("a", []string{}))
}

func TestSubset(t *testing.T) {
	assert.True(t, Subset([]string{}, []string{"b"}))
	assert.True(t, Subset([]string{"a", "b"}, []string{"a", "b", "c"}))
	assert.False(t, Subset([]string{"a", "b"}, []string{"b", "c"}))
}

func TestEquivalent(t *testing.T) {
	assert.False(t, Equivalent([]string{}, []string{"b"}))
	assert.True(t, Equivalent([]string{"a", "c", "b"}, []string{"a", "b", "c"}))
	assert.False(t, Equivalent([]string{"a", "b"}, []string{"b", "c"}))
}
