#!/usr/bin/perl

open (FILE, "alphabetical-functions.txt") or die "rip";

while (<FILE>) {
    chomp;
    my $function = $_;
    my $function_snake = $function;
    $function_snake =~ s/((?<=[a-z])[A-Z][a-z]+)/_\L$1/g;
    $function_snake =~ s/(\b[A-Z][a-z]+)/\L$1/g;

    my $alarm = <<"END_LITERAL";
module "alarm_$function_snake" {
  source = "../twirpalarm"

  namespace                 = "discovery"
  environment               = "\${var.environment}"
  region                    = "\${data.aws_region.current.name}"
  function_snake            = "$function_snake"
  function_camel            = "$function"
  alarm_actions             = ["\${module.discovery.alerts_sns_topic_arn}"]
  ok_actions                = ["\${module.discovery.alerts_sns_topic_arn}"]
  insufficient_data_actions = ["\${module.discovery.alerts_sns_topic_arn}"]
}

END_LITERAL

    print $alarm . "\n";
}
