#!/usr/bin/perl -w

use strict;

sub usage() {
	print <<"EOD";
usage: $0 <environment>

Acceptable environment flags: staging, production
EOD
}

if (scalar(@ARGV) != 1) {
	usage();
	exit(1);
}

my $environment = lc $ARGV[0]; chomp($environment);

unless ($environment =~ /^(?:staging|production)$/i) {
	print "Invalid environment: '$environment'\n";
	usage();
	exit(1);
}

open (FILE, "alphabetical-functions.txt") or die "rip";
my $y = 0;

while (<FILE>) {
    chomp;
    my $function = $_;
    my $function_snake = $function;
    $function_snake =~ s/((?<=[a-z])[A-Z][a-z]+)/_\L$1/g;
    $function_snake =~ s/(\b[A-Z][a-z]+)/\L$1/g;

    my $alarm = <<"END_LITERAL";
        {
            "type": "metric",
            "x": 0,
            "y": $y,
            "width": 6,
            "height": 6,
            "properties": {
                "metrics": [
                    [ "discovery", "Success", "Region", "us-west-2", "Service", "discovery", "Stage", "$environment", "Operation", "$function", "Substage", "primary" ]
                ],
                "view": "timeSeries",
                "stacked": false,
                "region": "us-west-2",
                "title": "$function",
                "period": 60,
                "stat": "Sum"
            }
        },
        {
            "type": "metric",
            "x": 6,
            "y": $y,
            "width": 6,
            "height": 6,
            "properties": {
                "metrics": [
                    [ "discovery", "ServerError", "Service", "discovery", "Stage", "$environment", "Region", "us-west-2", "Operation", "$function", "Substage", "primary" ]

                ],
                "view": "timeSeries",
                "stacked": false,
                "region": "us-west-2",
                "title": "$function",
                "period": 60,
                "stat": "Sum"
            }
        },
        {
            "type": "metric",
            "x": 12,
            "y": $y,
            "width": 6,
            "height": 6,
            "properties": {
                "metrics": [
                    [ "discovery", "ClientError", "Service", "discovery", "Stage", "$environment", "Region", "us-west-2", "Operation", "$function", "Substage", "primary" ]
                ],
                "view": "timeSeries",
                "stacked": false,
                "region": "us-west-2",
                "title": "$function",
                "period": 60,
                "stat": "Sum"
            }
        },
        {
            "type": "metric",
            "x": 18,
            "y": $y,
            "width": 6,
            "height": 6,
            "properties": {
                "metrics": [
                    [ "discovery", "Duration", "Region", "us-west-2", "Service", "discovery", "Stage", "$environment", "Operation", "$function", "Substage", "primary" ]
                ],
                "view": "timeSeries",
                "stacked": false,
                "region": "us-west-2",
                "title": "$function",
                "period": 60,
                "stat": "p99",
                "yAxis": {
                    "left": {
                        "showUnits": true
                    }
                }
            }
        },
END_LITERAL
	

    print $alarm;
    $y += 6;
}
