# Template for creating alarms on a twirp function
variable namespace {
  type        = "string"
  description = "name of the service"
}

variable environment {
  type        = "string"
  description = "staging or production"
}

variable region {
  type        = "string"
  description = "region eg us-west-2"
}

variable function_snake {
  type        = "string"
  description = "name of function snake style"
}

variable function_camel {
  type        = "string"
  description = "name of function in cloudwatch which should be camel case"
}

variable alarm_actions {
  type        = "list"
  description = "list of the ARNs to be notified when the alarm alarms"
}

variable ok_actions {
  type        = "list"
  description = "list of the ARNs to be notified when the alarm stops alarming"
}

variable insufficient_data_actions {
  type        = "list"
  description = "list of the ARNs to be notified when the alarm doesn't have enough data to evaluate its state"
}

variable treat_missing_data {
  type        = "string"
  default     = "notBreaching"
  description = "Sets how this alarm is to handle missing data points. The following values are supported: missing, ignore, breaching and notBreaching. Defaults to notBreaching (different than base terraform)."
}

resource "aws_cloudwatch_metric_alarm" "success_rate_alarm" {
  alarm_name                = "${var.namespace}_${var.function_snake}_success_rate"
  comparison_operator       = "LessThanOrEqualToThreshold"
  evaluation_periods        = "2"
  threshold                 = "99"
  alarm_description         = "${var.function_camel} success rate dropped below 99%"
  treat_missing_data        = var.treat_missing_data

  alarm_actions             = var.alarm_actions
  ok_actions                = var.ok_actions
  insufficient_data_actions = var.insufficient_data_actions

  metric_query {
    id          = "e1"
    expression  = "100*m1/(m1+m2)"
    label       = "Success Rate"
    return_data = "true"
  }

  metric_query {
    id = "m1"

    metric {
      metric_name = "Success"
      namespace   = var.namespace
      period      = "60"
      stat        = "Sum"
      unit        = "Count"

      dimensions = {
        Region    = var.region
        Service   = var.namespace
        Operation = var.function_camel
        Stage     = var.environment
        Substage  = "primary"
      }
    }
  }

  metric_query {
    id = "m2"

    metric {
      metric_name = "ServerError"
      namespace   = var.namespace
      period      = "60"
      stat        = "Sum"
      unit        = "Count"

      dimensions = {
        Region    = var.region
        Service   = var.namespace
        Operation = var.function_camel
        Stage     = var.environment
        Substage  = "primary"
      }
    }
  }
}
