# Provide the current account's ID
data "aws_caller_identity" "current" {
}

# Provide the region most of our resources are in (us-west-2)
data "aws_region" "current" {
}

# The terraform.tfstate file that #systems created when they set up the VPC for us in SYS-14154 and SYS-14153
data "terraform_remote_state" "vpc_setup" {
  backend = "s3"

  config = {
    bucket  = "twitch-ext-disco-dev"
    key     = "tfstate/systems/vpc-terraform/nonprod/twitch-ext-disco-dev/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-ext-disco-dev"
  }
}

data "aws_security_group" "default" {
  vpc_id = data.terraform_remote_state.vpc_setup.outputs.us_west_2_vpc_id
  name   = "default"
}

# Get the SG created by the cloudformation template for the bastion hosts so it can be referenced
# in the SG settings for the RDS instance
data "aws_security_group" "bastion_host_security_group" {
  vpc_id = data.terraform_remote_state.vpc_setup.outputs.us_west_2_vpc_id
  filter {
    name = "tag:Name"
    values = ["teleport-remote-jumpbox-twitch-ext-disco-dev-us-west-2-production"]
  }
}
