# Create the read only audit account used by twitch-central-aws to scan for vulnerabilities, etc.
module "read_only_audit_account" {
  source  = "git::ssh://git@git-aws.internal.justin.tv/gds/terraform-inventory_read_only"
  account = data.aws_caller_identity.current.account_id
}

# Make it possible for grafana to access cloudwatch metrics in this account
module "grafana_setup" {
  source = "git::ssh://git@git-aws.internal.justin.tv/gds/terraform-cloudwatch_grafana_access"
}

