variable "owner" {
  default = "twitch-ext-disco-dev@amazon.com"
}

variable "service" {
  default = "extensions/discovery"
}

variable "account_name" {
  default = "twitch-ext-disco-dev"
}

variable "region" {
  type    = string
  default = "us-west-2"
}

variable "component" {
  type    = string
  default = "discovery"
}

variable "environment" {
  type    = string
  default = "staging"
}

# This can be empty in dev because the lambda auto-approves deployments to all environments other than prod
variable "slack_webhook_url" {
  type        = string
  description = "The URL for your slack webhook integration, to be used by the lambda that asks you to manually approve the CodeDeploy pipeline for production"
  default     = ""
}

variable "ldap_hostname" {
  description = "The DNS name created by the tps.internal.justin.tv website when we created the VPC endpoint in this account.  Not managed by terraform, just documented here because it's infra."
  default     = "ldap-vpce-03210327929d3dc6b.internal.justin.tv"
}

