data "aws_acm_certificate" "discovery_ssl_certificate" {
  #
  # The domain needs to be a wildcard domain so users of your service can create their own DNS entries
  # pointing to the VPC Endpoints in their own VPCs that connect up to your LB, so SSL hostname validation
  # works.
  # e.g. they will want to create ${vpc_id}.staging.ext-discovery.us-west-2.internal.justin.tv IN CNAME
  #       ${their_vpc_endpoint_hostname}
  # so their services can resolve something that points to the interface in their own account that is connected
  # to your account.
  #
  domain = "*.${var.environment}.ext-discovery.${data.aws_region.current.name}.internal.justin.tv"

  statuses    = ["ISSUED"]
  most_recent = true
}

data "aws_iam_policy_document" "cloudwatch_putmetricdata" {
  statement {
    sid = "1"

    actions = [
      "cloudwatch:PutMetricData",
    ]

    resources = [
      "*",
    ]
  }
}
