variable "new_upload_service_arn" {
  default = "arn:aws:iam::435569175256:role/prod-upload-service"
}

//
// This bucket policy allows anonymous users to read from the bucket, which is
// required for serving a website out of it via cloudfront.
//
resource "aws_s3_bucket_policy" "discovery_images_bucket_policy" {
  bucket = aws_s3_bucket.discovery_images.id

  policy = <<POLICY
{
	"Version":"2012-10-17",
	"Statement":[{
		"Sid": "PublicReadGetObject",
		"Effect": "Allow",
		"Principal": "*",
		"Action": ["s3:GetObject"],
		"Resource": ["${aws_s3_bucket.discovery_images.arn}/*"]
	},
	{
		"Sid": "UploadServicePut",
		"Effect": "Allow",
		"Principal": {
			"AWS": [
				"${var.new_upload_service_arn}"
			]
		},
		"Action": ["s3:PutObject", "s3:PutObjectAcl"],
		"Resource": ["${aws_s3_bucket.discovery_images.arn}/*"]
	}]
}
POLICY

}

//
// This bucket stores extensions discovery images - the logo, discovery, and taskbar icon images, as well
// as screenshots.  Content is served via cloudfront and is uploaded via the upload service.
//
resource "aws_s3_bucket" "discovery_images" {
  bucket = "${var.account_name}-discovery-images"
  acl = "public-read"

  tags = {
    "twitch:s3:purpose" = "extensions-discovery-images"
    "twitch:s3:env" = var.environment
    "twitch:s3:app" = var.service
  }

  website {
    index_document = "index.html"
  }

  cors_rule {
    allowed_headers = [
      "Authorization",
    ]

    allowed_methods = [
      "GET",
    ]

    allowed_origins = [
      "*",
    ]

    max_age_seconds = 3000
  }
}

