variable "owner" {
  default = "twitch-ext-disco-prod@amazon.com"
}

variable "service" {
  default = "extensions/discovery"
}

variable "account_name" {
  default = "twitch-ext-disco-prod"
}

variable "region" {
  type    = string
  default = "us-west-2"
}

variable "component" {
  type    = string
  default = "discovery"
}

variable "environment" {
  type    = string
  default = "production"
}

variable "pagerduty_integration_key" {
  description = "The Integration Key from the integration tab on the PagerDuty Service Details page for the service this component is in"
  default     = ""
}

variable "slack_webhook_url" {
  type        = string
  description = "The URL for your slack webhook integration, to be used by the lambda that asks you to manually approve the CodeDeploy pipeline for production"
  default     = ""
}

variable "ldap_hostname" {
  default = "ldap-vpce-0dff20e681b907ff4.internal.justin.tv"
}

