package auth

import wp "code.justin.tv/gds/gds/extensions/whitelist/protocol"

// FakeCredentials implement Credentials that can be used in unit testing
type FakeCredentials struct {
	AllowEditAll  bool
	AllowViewAll  bool
	AllowedToView []wp.Action
	AllowedToEdit []wp.Action
	ClientIDValue string
	UserIDValue   string
}

// NoPermissions returns a default credential that has no permissions
func NoPermissions() Credentials { return new(FakeCredentials) }

// CanViewWhitelist returns true if the caller has view permissions for a particular whitelist
func (f *FakeCredentials) CanViewWhitelist(action wp.Action) bool {
	return f.AllowViewAll || action.In(f.AllowedToView)
}

// CanEditWhitelist returns true if the caller has edit permissions for a particular whitelist
func (f *FakeCredentials) CanEditWhitelist(action wp.Action) bool {
	return f.AllowEditAll || action.In(f.AllowedToEdit)
}

// CanListWhitelists returns true if the caller has global read permissions
func (f *FakeCredentials) CanListWhitelists() bool { return f.AllowViewAll }

// ClientID returns the clientID of the caller
func (f *FakeCredentials) ClientID() string { return f.ClientIDValue }

// UserID returns the userID of the caller if set
func (f *FakeCredentials) UserID() *string {
	if f.UserIDValue != "" {
		return &f.UserIDValue
	}
	return nil
}
