package auth

import (
	"net/http"
)

// FakeHandler serves its Credentials field or NoPermissions() if that
// field is not set.
type FakeHandler struct {
	Credentials Credentials
}

// GetCredentials implements Handler
func (f *FakeHandler) GetCredentials(r *http.Request) (Credentials, error) {
	if f.Credentials == nil {
		return NoPermissions(), nil
	}
	return f.Credentials, nil
}
