package protocol

// The contents of this file are used by Cartman to create a self-signed token
// indicating a direct token; the capability is not meant to be available to
// other clients, which allows the system to know that this is a direct
// connection.  Since only Cartman has the ES256 secret necessary to sign these
// tokens we trust the content originated from the correct service.
const (
	// CartmanJwtAudience will be used to detect tokens for whitelist use
	CartmanJwtAudience = "code.justin.tv/gds/whitelist"
	// CartmanParamAction is used as a capability parameter for view_whitelist and edit_whitelist
	CartmanParamAction = "action"
	// CartmanViewCapability is used to request access to view a single whitelist
	CartmanViewCapability = "extensions::view_whitelist"
	// CartmanEditCapability is used to request access to edit a single whitelist
	CartmanEditCapability = "extensions::edit_whitelist"
)
