package protocol

// All of the content here has a limited shelf life during migration
// from the current system.

const (
	// LegacyApprove exists only for backward compatibility
	LegacyApprove = "ApproveExtensions"
	// LegacyCreate exists only for backward compatibility
	LegacyCreate = "AddExtension"
	// LegacyReject exists only for backward compatibility
	LegacyReject = "RejectExtension"
	// LegacyEditAllCategories exists only for backward compatibility
	LegacyEditAllCategories = "EditAllCategories"
	// LegacyCurateAllCategories exists only for backward compatibility
	LegacyCurateAllCategories = "CurateCategories"
)

// ConvertFromLegacyName should be used when mapping from EMS queries
func ConvertFromLegacyName(value string) Action {
	switch value {
	case LegacyCreate:
		return CreateExtensions
	case LegacyApprove:
		return ReviewExtensions
	case LegacyCurateAllCategories:
		return CurateAllCategories
	case LegacyEditAllCategories:
		return EditAllCategories
	case LegacyReject:
		return ModerateExtensions
	default:
		return Action(value)
	}
}

// ConvertToLegacyName should be used when mapping to EMS queries
func ConvertToLegacyName(value Action) string {
	switch value {
	case CreateExtensions:
		return LegacyCreate
	case CurateAllCategories:
		return LegacyCurateAllCategories
	case EditAllCategories:
		return LegacyEditAllCategories
	case ModerateExtensions:
		return LegacyReject
	case ReviewExtensions:
		return LegacyApprove
	default:
		return string(value)
	}
}
