# dynamodb-replication
This repository contains code that helps to handle cross-account DynamoDB migration and replication.

## Files
### dynamo-sync.py
Usage: `python3 dynamo-sync.py` after filling out required source and target variables.

This file is a one-off script that can be run on an EC2 instance for larger Dynamo tables, or your personal computer for smaller tables (100,000 and less). This script runs fairly quickly, copying ~3 million records in a few hours.

### cross-account-s3-write.py
Usage: `Lambda` using Python 3.x in the `source` account after setting up env variables or constants.

This lambda code requires a trigger on the `source` DynamoDB table and the `source` table needs DynamoDB streams enabled with NEW images only (this can be easily setup via the DynamoDB table configuration). This code captures each new action taken on the `source` table, and writes the [Record](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_Record.html) to an S3 bucket in the target account.

### s3-file-to-dynamo-write.py
Usage: `Lambda` using Python 3.x in the `target` account after setting up env variables or constants.

This lambda code requires a trigger on the `target` account's S3 bucket to perform actions on each new item. This code processes the S3 file, extracts target table and keys, and performs the Insert / Update (PUT), or Delete on the targeted key. 

## Migration and Replication Process
### Setup
1. Set up Lambda in `source` account with `cross-account-s3-write.py` code and a disabled trigger on the `source` table's stream. We will call the `target` S3 bucket: `s3-pre-sync`
2. Set up Lambda in `target` account with `s3-file-to-dynamo-write.py` code and an enabled trigger on a `target` account S3 bucket. This bucket should be different bucket than the one above, we will call this `s3-post-sync`.
3. Enable DynamoDB streams on `source` table by going to AWS Console -> DynamoDB -> Target Table -> Overview -> Stream Details Section. We will select the NEW images only option.
4. Set up an EC2 instance with Python3 to run the `dynamo-sync.py` script.

### Migration
5. Enable the trigger on the Lambda source account that we set up previously. Files will begin being written to the cross account `s3-pre-sync` bucket.
6. Start running the `dynamo-sync.py` script inside the EC2 Instance. Records will be copied to the `target` Dynamo table.

### Replication
7. After the sync job is complete, we want to continue replication. To do this, we will sync the two S3 buckets, `s3-pre-sync` and `s3-post-sync`. You can do this manually, or set up a CRON job to do the sync every minute.
8. For each new file synced to the `s3-post-sync` bucket, the update will be written by the Lambda to the DynamoDB table.
9. Cut a PR to switch over to the `target` account's new DynamoDB tables and after deploy, the replication should stop.

### Clean Up
10. Disable all Lambda triggers and remove Lambdas.
11. Stop EC2 instance with sync script.
12. Delete created S3 buckets.
13. Delete old DynamoDB tables (if necessary)
