import json, boto3

CROSS_ACCOUNT_ROLE_S3_ACCESS=''
CROSS_ACCOUNT_S3_BUCKET=''

def get_s3_client():
  sts_connection = boto3.client('sts')
  acct_b = sts_connection.assume_role(
      RoleArn=CROSS_ACCOUNT_ROLE_S3_ACCESS,
      RoleSessionName='cross_acct_lambda',
      DurationSeconds=60
  )

  ACCESS_KEY = acct_b['Credentials']['AccessKeyId']
  SECRET_KEY = acct_b['Credentials']['SecretAccessKey']
  SESSION_TOKEN = acct_b['Credentials']['SessionToken']

  return boto3.client(
        's3',
        aws_access_key_id=ACCESS_KEY,
        aws_secret_access_key=SECRET_KEY,
        aws_session_token=SESSION_TOKEN,
  )
  
def perform_s3_upload(record):
  s3_client = get_s3_client()
  s3_client.put_object(Bucket=CROSS_ACCOUNT_ROLE_S3_ACCESS, Key=record['eventID'], Body=json.dumps(record))
  
def lambda_handler(event, context):
    #print("Received event: " + json.dumps(event, indent=2))
    for record in event['Records']:
      perform_s3_upload(record)

    return 'Successfully processed {} records.'.format(len(event['Records']))
