# Eastwatch

## Overview

This project provides a framework and tooling to support end-to-end integration testing either via the GraphQL edge or a mixture of the Visage edge & Cartman/EMS endpoints.

Additional documentation can be found on the [wiki](https://wiki.twitch.com/display/EDM/Eastwatch)

## Requirements

- AWS Credidentials configured to access Sandstorm secrets (create IAM user with your alias in `twitch-gds-dev` using AWS console)
- Connected To Twitch VPN
- [Counterfeiter](https://github.com/maxbrunsfeld/counterfeiter). You can install it with `go get -u https://github.com/maxbrunsfeld/counterfeiter`

## Running the tests

- `bin/test` to run test on your local machine
- `AWS_PROFILE=twitch_ds_dev go test {{YOUR_TEST_FILE}}` to run a specific test (you need to have `twitch_ds_dev` set in your aws credential file)
- `AWS_ACCESS_KEY_ID={{YOUR_STAGING_ID}} AWS_SECRET_ACCESS_KEY={{YOUR_STAGING_KEY}} AWS_REGION=us-west-2 bin/run_tests` to run the tests as Jenkins runs them (using docker compose)

## Project Organization

There are 2 parts to this project

- `/internal` contain all of the code necessary to call the various upstreams. If you need to add support for an endpoint or behavior of an upstream system you would do that here.
- `/test` contain the end-to-end integration tests, which utilizes the packages above.

## Writing an integration test

To create an integration test, do:

1. Declare the internal APIs on a client in `/internal/api/{{CLIENT_NAME}}/client.go`
2. Define the internal APIs of a client as `/internal/api/{{CLIENT_NAME}}/{{INTERFACE_NAME}}.go`
3. Run `go generate client.go` to generate the fake client for local test [Counterfeiter](https://github.com/maxbrunsfeld/counterfeiter) is required).
    - Run `export PATH=$PATH:$GOPATH/bin` first if you get an error of `running "counterfeiter": exec: "counterfeiter": executable file not found in $PATH`
4. Create the tests in the relavant test folder (see below) that initilizes internal api clients and then uses the behaviors of the client(s) to interact with the upstream systems. There are 2 tests folders:
    - `/test/gql` - for graphql tests
    - `/test/legacy` - for visage or other legacy tests

Using a Testify Suite test is optional, but can be helpful in organization, again follow the current imlementation for an example and embed the `test.EastwatchSuite` struct instead of Testify's `suite.Suite` to get a base `HTTPClient` which prints the requests & responses and some other helpful functions.
