package cartman

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
	cartmanclient "code.justin.tv/web/cartman/client"
)

//go:generate counterfeiter -o ./cartmanfakes/fake_cartman_client.go --fake-name FakeCartmanClient ../../../vendor/code.justin.tv/web/cartman/client Client
//go:generate counterfeiter . Client

// Client defines a simple cartman client that can retrieve a cartman jwt
type Client interface {
	// GetToken retrieves and returns a cartman jwt
	GetToken(oauth token.OAuth, caps []string, opts ...Option) (token.JWT, error)
}

// Option is a cartman request option
type Option func(*cartmanclient.RequestParams)

type client struct {
	c cartmanclient.Client
}

// NewClient creates a client that can retrieve a cartman jwt
func NewClient(c cartmanclient.Client) Client {
	return &client{c: c}
}
