package cartman

import (
	"context"
	"errors"
	"net/http"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	cartmanclient "code.justin.tv/web/cartman/client"
)

// ForChannel sets the channel_id cartman parameter
func ForChannel(id string) Option {
	return Option(func(p *cartmanclient.RequestParams) {
		p.Params["channel_id"] = id
	})
}

// ForExtension sets the extension_id and extension_version cartman parameters
func ForExtension(id, version string) Option {
	return Option(func(p *cartmanclient.RequestParams) {
		p.Params["extension_id"] = id
		p.Params["extension_version"] = version
	})
}

func (c *client) GetToken(t token.OAuth, caps []string, opts ...Option) (token.JWT, error) {
	if len(caps) == 0 {
		return "", errors.New("no cartman capabilities requested")
	}

	origin, err := http.NewRequest(http.MethodGet, "/", nil)
	if err != nil {
		return "", err
	}

	origin.Header.Add(cartmanclient.AuthorizationHeader, t.HeaderValue())

	params := cartmanclient.RequestParams{
		Capabilities: caps,
		Params: map[string]string{
			cartmanclient.KeyParam: "ecc.key",
		},
		Origin: origin,
	}
	for _, opt := range opts {
		opt(&params)
	}

	response, err := c.c.GetAuthorizationToken(context.Background(), params, nil)
	if err != nil {
		return "", err
	}

	return token.NewJWT(response.Token)
}
