package ems

import (
	"context"
	"fmt"
	"net/http"
	"net/url"
	"path"
)

type AnchorType string

const (
	// Hidden anchors are used for testing purposes only and are invisible to users
	Hidden AnchorType = "hidden"

	// VideoOverlay anchors are placed directly on top of streaming video
	VideoOverlay AnchorType = "video_overlay"

	// Panel anchors appear in the channel page below the video
	Panel AnchorType = "panel"

	// Component anchors appear on top of streaming video
	Component AnchorType = "component"
)

func (c *client) AdminDeactivateExtension(channelID string, anchorType AnchorType, slot Slot) error {
	//DELETE /admin/channels/:channelid/:anchor_type/:slot
	path, err := url.Parse(path.Join("/admin/channels", channelID, string(anchorType), string(slot)))

	if err != nil {
		return err
	}

	req, err := c.buildRequest(context.Background(), "AdminDeactivateExtension", http.MethodDelete, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return err
	}

	resp, err := c.http.Do(req)
	if err != nil {
		return err
	}

	if resp.StatusCode != http.StatusNoContent {
		return fmt.Errorf("admin deactivate extension unsuccessful [%s]", resp.Status)
	}
	return nil
}
