package ems

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"

	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) AdminDumpExtensions(doc documents.GetExtensionsParams) (documents.AdminExtensionsDocument, error) {
	//POST /admni/extensions (not a typo)
	path, err := url.Parse("/admni/extensions")
	var out documents.AdminExtensionsDocument

	if err != nil {
		return out, err
	}

	body, err := json.Marshal(doc)
	if err != nil {
		return out, err
	}

	req, err := c.buildRequest(context.Background(), "AdminDumpExtensions", http.MethodPost, c.baseURL.ResolveReference(path).String(), bytes.NewBuffer(body))
	if err != nil {
		return out, err
	}

	resp, err := c.http.Do(req)
	if err != nil {
		return out, err
	}

	if resp.StatusCode != http.StatusOK {
		return out, fmt.Errorf("admin dump extensions unsuccessful [%s]", resp.Status)
	}

	err = json.NewDecoder(resp.Body).Decode(&out)
	return out, err
}
