package ems

import (
	"context"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/gds/gds/extensions/ems/documents"
)

func (c *client) GetChannelExtensionOAuth(cid, eid string) (documents.ExtensionInstallationOAuthResponse, error) {
	//GET /channels/:cid/extensions/:eid/oauth
	path, err := url.Parse(path.Join("/channels", cid, "/extensions", eid, "/oauth"))

	var out documents.ExtensionInstallationOAuthResponse

	if err != nil {
		return out, err
	}

	req, err := c.buildRequest(context.Background(), "GetChannelExtensionOAuth", http.MethodGet, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return out, err
	}

	resp, err := c.http.Do(req)
	if err != nil {
		return out, err
	}

	if resp.StatusCode != http.StatusOK {
		return out, fmt.Errorf("get extension installation oauth unsuccessful [%s]", resp.Status)
	}

	err = json.NewDecoder(resp.Body).Decode(&out)

	return out, err
}
