package ems

import (
	"context"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/foundation/twitchclient"
)

func (c *client) HardDeleteExtension(t token.JWT, extensionID string) error {
	// DELETE admin/extensions/:id
	path, err := url.Parse(path.Join("admin/extensions", extensionID))
	if err != nil {
		return err
	}

	req, err := c.buildRequest(context.Background(), "HardDeleteExtension", http.MethodDelete, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return err
	}
	req.Header.Set(twitchclient.TwitchAuthorizationHeader, t.String())

	resp, err := c.http.Do(req)
	if err != nil {
		return err
	}

	if resp.StatusCode != http.StatusNoContent {
		return fmt.Errorf("hard delete extension unsuccessful [%s]", resp.Status)
	}

	return nil
}
