package ems

import (
	"context"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/foundation/twitchclient"
)

// InstallExtensionRequest define the required details needed to install an extension via EMS
type InstallExtensionRequest struct {
	ChannelID        string
	ExtensionID      string
	ExtensionVersion string
}

// InstallExtension will install an extension onto a channel
func (c *client) InstallExtension(t token.JWT, r InstallExtensionRequest) error {
	// POST /channels/:cid/extensions/:eid/:version/v2
	path, err := url.Parse(path.Join("channels", r.ChannelID, "extensions", r.ExtensionID, r.ExtensionVersion, "v2"))
	if err != nil {
		return err
	}

	req, err := c.buildRequest(context.Background(), "InstallExtension", http.MethodPost, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return err
	}
	req.Header.Set(twitchclient.TwitchAuthorizationHeader, t.String())

	resp, err := c.http.Do(req)
	if err != nil {
		return err
	}

	if resp.StatusCode != http.StatusOK {
		return fmt.Errorf("install extension unsuccessful [%s]", resp.Status)
	}

	return nil
}
