package ems

import (
	"context"
	"fmt"
	"net/http"
	"net/url"
	"path"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
	"code.justin.tv/foundation/twitchclient"
)

// UninstallExtensionRequest defines the required details needed to uninstall an extension via EMS
type UninstallExtensionRequest struct {
	ChannelID        string
	ExtensionID      string
	ExtensionVersion string
}

// UninstallExtension will uninstall an extension from a channel
func (c *client) UninstallExtension(t token.JWT, r UninstallExtensionRequest) error {
	// DELETE /channels/:cid/extensions/:eid/:version
	path, err := url.Parse(path.Join("channels", r.ChannelID, "extensions", r.ExtensionID, r.ExtensionVersion))
	if err != nil {
		return err
	}

	req, err := c.buildRequest(context.Background(), "UninstallExtension", http.MethodDelete, c.baseURL.ResolveReference(path).String(), nil)
	if err != nil {
		return err
	}
	req.Header.Set(twitchclient.TwitchAuthorizationHeader, t.String())

	resp, err := c.http.Do(req)
	if err != nil {
		return err
	}

	if resp.StatusCode != http.StatusNoContent {
		return fmt.Errorf("uninstall extension unsuccessful [%s]", resp.Status)
	}

	return nil
}
