package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

// PanelSlot is a slot for a panel activation
type PanelSlot string

// VideoOverlaySlot is a slot for a video overlay activation
type VideoOverlaySlot string

func (s PanelSlot) String() string {
	return string(s)
}

func (s VideoOverlaySlot) String() string {
	return string(s)
}

const (
	// PanelSlotExtension1 is the left most extension panel
	PanelSlotExtension1 PanelSlot = "extension-panel-1"

	// PanelSlotExtension2 is the middle extension panel
	PanelSlotExtension2 PanelSlot = "extension-panel-2"

	// PanelSlotExtension3 is the right most extension panel
	PanelSlotExtension3 PanelSlot = "extension-panel-3"

	VideoOverlaySlotExtension1 VideoOverlaySlot = "extension-overlay-1"
)

// ExtensionActivationsInput is required for ApplyExtensionActivationsInput
type ExtensionActivationsInput struct {
	InstallationID string                       `json:"installationID"`
	Panel          *PanelActivationInput        `json:"panel"`
	VideoOverlay   *VideoOverlayActivationInput `json:"videoOverlay"`
}

// PanelActivationInput is required for ApplyExtensionActivationsInput
type PanelActivationInput struct {
	Slot PanelSlot `json:"slot"`
}

// VideoOverlayActivationInput is required for ApplyExtensionActivationsInput
type VideoOverlayActivationInput struct {
	Slot VideoOverlaySlot `json:"slot"`
}

func (c *client) ApplyExtensionActivations(t token.OAuth, channelID string, activations ...ExtensionActivationsInput) ([]InstalledExtension, error) {
	var body struct {
		ApplyExtensionActivations struct {
			InstalledExtensions []InstalledExtension `json:"installedExtensions"`
		} `json:"applyExtensionActivations"`
	}

	op, found := c.mutation["apply_extension_activations"]
	if !found {
		return nil, ErrOperationNotFound
	}

	input := map[string]interface{}{
		"channelID":   channelID,
		"activations": activations,
	}
	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return nil, err
	}

	err = b.Unmarshal(&body)
	if err != nil {
		return nil, err
	}

	return body.ApplyExtensionActivations.InstalledExtensions, nil
}
