package gql

import (
	"encoding/json"
	"fmt"
)

// Body are the bytes returned from a gql operation
type Body []byte

type gqlResponse struct {
	Data       interface{}   `json:"data"`
	Errors     []gqlError    `json:"errors"`
	Extensions gqlExtensions `json:"extensions"`
}

type gqlError struct {
	Message string   `json:"message"`
	Path    []string `json:"path"`
}

func (err gqlError) Error() string {
	return fmt.Sprintf("%s %v", err.Message, err.Path)
}

type gqlExtensions struct {
	DurationMilliseconds int    `json:"durationMilliseconds"`
	OperationName        string `json:"operationName"`
}

// Unmarshal will unmarshal the data value within the graphql response body
func (b Body) Unmarshal(v interface{}) error {
	r := gqlResponse{Data: v}
	json.Unmarshal([]byte(b), &r)
	if len(r.Errors) > 0 {
		return r.Errors[0]
	}
	return nil
}
