package gql_test

import (
	"fmt"
	"testing"

	"code.justin.tv/extensions/eastwatch/internal/api/gql"
	"github.com/stretchr/testify/assert"
)

func TestGQLError(t *testing.T) {

	const (
		errorMessage = "service error"
		errorPath1   = "path1"
		errorPath2   = "path2"
	)

	// this is what a gql response looks like with an errors value
	var bodyWithError = fmt.Sprintf(`
	{
        "data": {
            "theGQLMutationName": null
        },
        "errors": [
            {
                "message": "%s",
                "path": [
					"%s",
					"%s"
                ]
            }
        ],
        "extensions": {
            "durationMilliseconds": 100
        }
    }`, errorMessage, errorPath1, errorPath2)

	b := gql.Body(bodyWithError)

	var v interface{}
	err := b.Unmarshal(v)
	assert.Nil(t, v)
	assert.Equal(t, "service error [path1 path2]", fmt.Sprint(err))
}
