package gql

import (
	"errors"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) CreateExtensionClient(t token.OAuth, extensionName, redirectURI string) (ExtensionClient, error) {
	var body struct {
		CreateExtensionClient struct {
			Error  string          `json:"error"`
			Client ExtensionClient `json:"client"`
		} `json:"createExtensionClient"`
	}

	op, found := c.mutation["create_extension_client"]
	if !found {
		return ExtensionClient{}, ErrOperationNotFound
	}

	input := map[string]string{
		"name":        extensionName,
		"redirectURI": redirectURI,
	}
	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return ExtensionClient{}, err
	}

	err = b.Unmarshal(&body)
	if err != nil {
		return ExtensionClient{}, err
	}

	// domain error returned as part of the operation
	if body.CreateExtensionClient.Error != "" {
		return ExtensionClient{}, errors.New(body.CreateExtensionClient.Error)
	}

	return body.CreateExtensionClient.Client, nil
}
