package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) CreatePanel(t token.OAuth, channelID string, pt PanelType) (Panel, error) {
	var body struct {
		CreatePanel struct {
			Panel Panel `json:"panel"`
		} `json:"createPanel"`
	}

	op, found := c.mutation["create_panel"]
	if !found {
		return Panel{}, ErrOperationNotFound
	}

	input := map[string]string{
		"channelID": channelID,
		"type":      pt.String(),
	}
	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return Panel{}, err
	}

	err = b.Unmarshal(&body)
	if err != nil {
		return Panel{}, err
	}

	return body.CreatePanel.Panel, nil
}
