package gql

import (
	"errors"

	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) DeleteExtension(t token.OAuth, extensionID string) error {
	var body struct {
		DeleteExtension struct {
			Error string `json:"error"`
		} `json:"deleteExtension"`
	}

	op, found := c.mutation["delete_extension"]
	if !found {
		return ErrOperationNotFound
	}

	input := map[string]string{"id": extensionID}
	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return err
	}

	err = b.Unmarshal(&body)
	if err != nil {
		return err
	}

	if body.DeleteExtension.Error != "" {
		return errors.New(body.DeleteExtension.Error)
	}

	return nil
}
