package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) DeletePanel(t token.OAuth, panelID string) (Panel, error) {
	var body struct {
		DeletePanel struct {
			Panel Panel `json:"panel"`
		} `json:"deletePanel"`
	}

	op, found := c.mutation["delete_panel"]
	if !found {
		return Panel{}, ErrOperationNotFound
	}

	input := map[string]string{"id": panelID}
	b, err := c.executeMutation(t, op, input)
	if err != nil {
		return Panel{}, err
	}

	err = b.Unmarshal(&body)
	if err != nil {
		return Panel{}, err
	}

	return body.DeletePanel.Panel, nil
}
