package gql

import "errors"

const (

	// ErrCodeXXX match the error codes returned by the graphql calls
	ErrCodeUnauthorized              = "UNAUTHORIZED"
	ErrCodeInvalidChannelID          = "INVALID_CHANNEL_ID"
	ErrCodeExtensionAlreadyInstalled = "EXTENSION_ALREADY_INSTALLED"
	ErrCodeExtensionNotInstalled     = "EXTENSION_NOT_INSTALLED"
)

var (
	// ErrOperationNotFound describes an operation that was attempted to be used but was not found
	ErrOperationNotFound = errors.New("graphql operation not found")

	// ErrCodes wraps all ErrCodeXXX so that they could be iterated
	ErrCodes = []string{
		ErrCodeUnauthorized,
		ErrCodeInvalidChannelID,
		ErrCodeExtensionAlreadyInstalled,
		ErrCodeExtensionNotInstalled,
	}
)
