package gql

import (
	"code.justin.tv/extensions/eastwatch/internal/models/token"
)

func (c *client) GetCurrentUser(t token.OAuth) (User, error) {
	var out struct {
		User User `json:"currentUser"`
	}

	op, found := c.query["current_user"]
	if !found {
		return out.User, ErrOperationNotFound
	}
	b, err := c.executeMutation(t, op, nil)
	if err != nil {
		return out.User, err
	}

	err = b.Unmarshal(&out)
	return out.User, err
}
